/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.ftp;

import com.quantumdata.ftp.CoFile;
import java.util.Date;
import java.util.Vector;

public class CoSort {
    private int sorttype;
    public static final int ORDER_BY_NAME = 1;
    public static final int ORDER_BY_TYPE = 2;
    public static final int ORDER_BY_SIZE = 3;
    public static final int ORDER_BY_DATE = 4;
    public static final int ORDER_BY_PATH = 5;
    public static final int ORDER_BY_NONE = 6;
    public static final int ORDER_INVERSE = 8;

    CoSort(int n) {
        this.sorttype = n;
    }

    private boolean Pause() throws Exception {
        return true;
    }

    private void Swap(CoFile[] coFileArray, int n, int n2) {
        CoFile coFile = coFileArray[n];
        coFileArray[n] = coFileArray[n2];
        coFileArray[n2] = coFile;
    }

    private boolean AgreaterB(CoFile coFile, CoFile coFile2) {
        boolean bl = false;
        switch (this.sorttype) {
            case 1: {
                bl = coFile.compareNameToIgnoreCase(coFile2) > 0;
                break;
            }
            case 2: {
                bl = coFile.compareExtToIgnoreCase(coFile2) > 0;
                break;
            }
            case 3: {
                bl = coFile.length() > coFile2.length();
                break;
            }
            case 4: {
                bl = new Date(coFile.lastModified()).after(new Date(coFile2.lastModified()));
                break;
            }
            case 5: {
                bl = coFile.compareToObj(coFile2) > 0;
            }
        }
        return bl;
    }

    private boolean AsmallerB(CoFile coFile, CoFile coFile2) {
        boolean bl = false;
        switch (this.sorttype) {
            case 1: {
                bl = coFile.compareNameToIgnoreCase(coFile2) < 0;
                break;
            }
            case 2: {
                bl = coFile.compareExtToIgnoreCase(coFile2) < 0;
                break;
            }
            case 3: {
                bl = coFile.length() < coFile2.length();
                break;
            }
            case 4: {
                bl = new Date(coFile.lastModified()).before(new Date(coFile2.lastModified()));
                break;
            }
            case 5: {
                bl = coFile.compareToObj(coFile2) < 0;
            }
        }
        return bl;
    }

    private void QuickSort(CoFile[] coFileArray, int n, int n2) throws Exception {
        int n3 = n;
        int n4 = n2;
        if (n2 > n) {
            CoFile coFile = coFileArray[(n + n2) / 2];
            while (n3 <= n4) {
                while (n3 < n2 && this.Pause() && this.AsmallerB(coFileArray[n3], coFile)) {
                    ++n3;
                }
                while (n4 > n && this.Pause() && this.AgreaterB(coFileArray[n4], coFile)) {
                    --n4;
                }
                if (n3 > n4) continue;
                this.Swap(coFileArray, n3, n4);
                ++n3;
                --n4;
            }
            if (n < n4) {
                this.QuickSort(coFileArray, n, n4);
            }
            if (n3 < n2) {
                this.QuickSort(coFileArray, n3, n2);
            }
        }
    }

    private void Sort(CoFile[] coFileArray) throws Exception {
        this.QuickSort(coFileArray, 0, coFileArray.length - 1);
        if ((this.sorttype & 8) > 0) {
            for (int i = 0; i < coFileArray.length / 2; ++i) {
                this.Swap(coFileArray, i, coFileArray.length - 1 - i);
            }
        }
    }

    public static CoFile[] listFilter(CoFile[] coFileArray, String[] stringArray) {
        if (stringArray.length != 0) {
            Vector<CoFile> vector = new Vector<CoFile>();
            for (int i = 0; i < coFileArray.length; ++i) {
                if (!coFileArray[i].isDirectory() && !coFileArray[i].isLink() && !coFileArray[i].equalsExtTo(stringArray)) continue;
                vector.addElement(coFileArray[i]);
            }
            Object[] objectArray = new CoFile[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return coFileArray;
    }

    public static CoFile[] listOrder(CoFile[] coFileArray, int n) {
        if ((n & 0xFFFFFFF7) != 6) {
            CoSort coSort = new CoSort(n);
            try {
                coSort.Sort(coFileArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return coFileArray;
        }
        return coFileArray;
    }

    public static CoFile[] listSplit(CoFile[] coFileArray) {
        int n;
        Vector<CoFile> vector = new Vector<CoFile>();
        for (n = 0; n < coFileArray.length; ++n) {
            if (!coFileArray[n].isDirectory() && !coFileArray[n].isLink()) continue;
            vector.addElement(coFileArray[n]);
        }
        for (n = 0; n < coFileArray.length; ++n) {
            if (coFileArray[n].isDirectory() || coFileArray[n].isLink()) continue;
            vector.addElement(coFileArray[n]);
        }
        Object[] objectArray = new CoFile[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }
}

